//								EJEMPLO 35
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El mdulo conversor ADC. Variando la anchura del pulso en una seal de salida
//
//Los dispositivos PIC16F87X disponen de un convertidor A/D de 10 bits de resolucin y 5 u 8 
//canales de entrada analgica. La tensin de referencia determina la resolucin por bit:
//(Res. = Vref/1024). Con 5 Vref=4.8 mV/Bit; con 2.5 Vref=2.4 mV/Bit
//
//Se propone realizar una modulacin de anchura de pulsos (PWM) mediante el mdulo CCP1 y con
//salida de seal por la lnea RC2/CCP1. Se establece un periodo fijo de 3200uS
//
//El TMR2 trabajando con un preescaler de 1:16 y a una frecuencia de 4 MHz evoluciona cada 16 uS
//
//Un osciloscopio conectado en RC2/CCP1 permitir visualizar las variaciones del ancho de pulso de la seal
//de salida segn la tensin analgica aplicada por RA0/AN0
	
#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use fast_io (C)
#use delay(clock=4000000)

int	periodo=200;		//Periodo de 3200uS (200*16*1)
int resultado;		//Variable para el resultado de la conversin AD

main()
{  	
	set_tris_c(0b11111011);	//RC2 salida
	setup_adc_ports(AN0);	//RA0 entrada analgica

//El TMR2 trabaja con un preescaler 1:16 por lo que con una frecuencia de 4MHz evoluciona
//cada 16uS ((4*Tosc)*16)

	setup_timer_2(T2_DIV_BY_16,periodo-1,1);	//Carga el periodo y TMR2 en ON	

//El mdulo CCP1 acta en el modo PWM con salida de seal por RC2/CCP1

	setup_ccp1(CCP_PWM);			//Modo PWM para el CCP1
	setup_adc(adc_clock_div_32);	//Ajusta frecuencia de muestreo del ADC

	while(1)
	{	

//Se activa el ADC y se selecciona el canal RA0/AN0.
	
		set_adc_channel(0);		//Seleccin del canal 0 (RA0)
		CCP_1_LOW=read_adc();	//Inicia la conversin y carga la anchura del pulso	
	}
}	
